import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:hive/hive.dart';
import 'package:wordpress_app/models/article.dart';
import 'package:wordpress_app/services/app_service.dart';
import 'package:wordpress_app/utils/cached_image.dart';
import 'package:wordpress_app/utils/next_screen.dart';
import 'package:wordpress_app/widgets/bookmark_icon.dart';
import 'package:wordpress_app/widgets/video_icon.dart';

import '../blocs/config_bloc.dart';
import '../constants/constant.dart';
import '../widgets/category_chip.dart';

//Big card with title
class Card4 extends ConsumerWidget {
  const Card4({super.key, required this.article, required this.heroTag});
  final Article article;
  final String? heroTag;

  @override
  Widget build(BuildContext context, WidgetRef ref) {
    final bookmarkedList = Hive.box(Constants.bookmarkTag);
    final configs = ref.read(configBlocProvider).configs!;
    final bool showDateTime = configs.showDateTime;

    return InkWell(
        child: Container(
            decoration: BoxDecoration(
              color: Theme.of(context).cardColor,
              borderRadius: BorderRadius.circular(5),
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Stack(
                  alignment: Alignment.center,
                  children: [
                    SizedBox(
                      height: 200,
                      width: double.infinity,
                      child: ClipRRect(
                          borderRadius: BorderRadius.circular(5),
                          child: HeroMode(
                            enabled: heroTag != null,
                            child: Hero(
                                tag: heroTag ?? '',
                                child: CustomCacheImage(
                                    imageUrl: article.image, radius: 0)),
                          )),
                    ),
                    VideoIcon(
                      article: article,
                      iconSize: 60,
                    )
                  ],
                ),
                Container(
                  padding: const EdgeInsets.only(top: 15),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      CategoryChip(article: article),
                      const SizedBox(
                        height: 10,
                      ),
                      Text(
                        AppService.getNormalText(article.title!),
                        maxLines: 3,
                        overflow: TextOverflow.ellipsis,
                        style: Theme.of(context)
                            .textTheme
                            .headlineSmall
                            ?.copyWith(
                                fontWeight: FontWeight.w600, fontSize: 18),
                      ),
                      Visibility(
                        visible: showDateTime,
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Icon(
                              CupertinoIcons.time,
                              size: 18,
                              color: Theme.of(context)
                                  .colorScheme
                                  .onSurfaceVariant,
                            ),
                            const SizedBox(
                              width: 3,
                            ),
                            Text(
                              AppService.getTime(article.date!, context),
                              maxLines: 1,
                              overflow: TextOverflow.ellipsis,
                              style: Theme.of(context)
                                  .textTheme
                                  .bodyMedium
                                  ?.copyWith(
                                      fontWeight: FontWeight.w500,
                                      color: Theme.of(context)
                                          .colorScheme
                                          .secondary),
                            ),
                            const Spacer(),
                            BookmarkIcon(
                              bookmarkedList: bookmarkedList,
                              article: article,
                              iconSize: 18,
                            )
                          ],
                        ),
                      )
                    ],
                  ),
                )
              ],
            )),
        onTap: () =>
            navigateToDetailsScreen(context, article, heroTag, configs));
  }
}
